/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.command;

import com.ibm.hsc.cim.client.pi.PIHSCProfileCIMClient;
import com.ibm.hsc.client.PICECDataBean;
import com.ibm.hsc.client.PIFrameDataBean;
import com.ibm.hsc.client.PIHSCCECClient;
import com.ibm.hsc.client.PIHSCClientObjectFactory;
import com.ibm.hsc.client.PIHSCFrameClient;
import com.ibm.hsc.client.PIHSCLPARClient;
import com.ibm.hsc.client.PIHSCSysProfClient;
import com.ibm.hsc.client.PILPARDataBean;
import com.ibm.hsc.client.PILPARProfileDataBean;
import com.ibm.hsc.client.PISysProfDataBean;
import com.ibm.hsc.command.PIHMCCommandUtils;
import com.ibm.hsc.command.PIProfCommandUtils;
import com.ibm.hsc.common.bundles.HSCResourceBundleUtil;
import com.ibm.hsc.common.exceptions.PIHscClientException;
import com.ibm.hsc.common.util.CSVRecord;
import com.ibm.hsc.common.util.PIHscUtil;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintStream;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import org.snia.wbem.cim.CIMException;
import org.snia.wbem.cim.UnsignedInt16;
import org.snia.wbem.cim.UnsignedInt8;

public class PISystemConfigurationChange {
    private static final String PARTITION_NAME_ATTR = "lpar_name";
    private static final int NUM_VALID_PARMS = 7;
    private String m_resourceType;
    private String m_managedSystem;
    private String m_filename;
    private String m_inputData;
    private String m_frame;
    private HashMap m_validParms = new HashMap(15, 0.5f);
    private Vector m_input;
    private String m_partName = null;
    private String m_partID = null;
    private String m_sysProfName = null;
    private String m_partProfName = null;
    private PIHSCClientObjectFactory m_factory = null;
    private PIHSCCECClient m_CECClient = null;
    private PIHSCFrameClient m_FrameClient = null;
    private String m_intSysName = null;
    private String m_delimiter = ",";
    private PrintStream m_out;
    private boolean m_writeStatus;

    private PISystemConfigurationChange(PIHSCFrameClient pIHSCFrameClient, PIHSCCECClient pIHSCCECClient, PrintStream printStream, boolean bl) {
        this.m_CECClient = pIHSCCECClient;
        this.m_FrameClient = pIHSCFrameClient;
        this.m_out = printStream;
        this.m_writeStatus = bl;
        if (this.m_CECClient != null) {
            this.m_intSysName = this.m_CECClient.getIntName();
        }
        this.m_validParms.put("-m", null);
        this.m_validParms.put("-r", null);
        this.m_validParms.put("-f", null);
        this.m_validParms.put("-i", null);
        this.m_validParms.put("-n", null);
        this.m_validParms.put("-p", null);
        this.m_validParms.put("-e", null);
    }

    private void setFrameData(PIFrameDataBean pIFrameDataBean, String string, String string2) throws PIHscClientException {
        boolean bl;
        block17: {
            bl = false;
            try {
                if ("new_name".equals(string)) {
                    pIFrameDataBean.setUserDefinedName(string2);
                    break block17;
                }
                if ("frame_num".equals(string)) {
                    int n = Integer.parseInt(string2);
                    if (n > 0 && n < 65536) {
                        pIFrameDataBean.setFrameNumber(new UnsignedInt16(string2));
                    } else {
                        bl = true;
                    }
                    break block17;
                }
                if ("power_on_side_a".equals(string)) {
                    if ("perm".equals(string2.toLowerCase())) {
                        pIFrameDataBean.setPlatformNextIplSideA(new UnsignedInt8(0));
                    } else if ("temp".equals(string2.toLowerCase())) {
                        pIFrameDataBean.setPlatformNextIplSideA(new UnsignedInt8(1));
                    } else {
                        bl = true;
                    }
                    break block17;
                }
                if ("power_on_side_b".equals(string)) {
                    if ("perm".equals(string2.toLowerCase())) {
                        pIFrameDataBean.setPlatformNextIplSideB(new UnsignedInt8(0));
                    } else if ("temp".equals(string2.toLowerCase())) {
                        pIFrameDataBean.setPlatformNextIplSideB(new UnsignedInt8(1));
                    } else {
                        bl = true;
                    }
                    break block17;
                }
                String[] stringArray = new String[]{string};
                throw new PIHscClientException("8000", "PIHscCmdLineBundle", "INVALID_ATTRIBUTE", stringArray, null);
            }
            catch (NumberFormatException numberFormatException) {
                bl = true;
            }
        }
        if (bl) {
            String[] stringArray = new String[]{string + "=" + string2};
            throw new PIHscClientException("8000", "PIHscCmdLineBundle", "INVALID_ATTRIBUTE_VALUE", stringArray, null);
        }
    }

    private void validateFrameData(PIFrameDataBean pIFrameDataBean) throws PIHscClientException {
        String string = pIFrameDataBean.getUserDefinedName();
        if (string != null) {
            try {
                if (!PIHscUtil.isCorrectNameLength(string, 63)) {
                    String[] stringArray = new String[]{string};
                    throw new PIHscClientException("8000", "PIHscCmdLineBundle", "INVALID_SYS_NAME_LENGTH", stringArray, null);
                }
                if (!PIHscUtil.nameHasCorrectCharacters(string)) {
                    String[] stringArray = new String[]{"new_name=" + string};
                    throw new PIHscClientException("8000", "PIHscCmdLineBundle", "INVALID_ATTRIBUTE_VALUE", stringArray, null);
                }
            }
            catch (CIMException cIMException) {
                String[] stringArray = new String[]{"new_name=" + string};
                throw new PIHscClientException("8000", "PIHscCmdLineBundle", "INVALID_ATTRIBUTE_VALUE", stringArray, null);
            }
        }
    }

    private void setSysData(PICECDataBean pICECDataBean, String string, String string2) throws PIHscClientException {
        String[] stringArray;
        boolean bl;
        block29: {
            bl = false;
            try {
                if ("new_name".equals(string)) {
                    pICECDataBean.setUserDefinedName(string2);
                    break block29;
                }
                if ("power_off_policy".equals(string)) {
                    stringArray = PIHMCCommandUtils.decodeBoolean(string2);
                    if (stringArray != null) {
                        pICECDataBean.setPowerOffPolicy((Boolean)stringArray);
                    } else {
                        bl = true;
                    }
                    break block29;
                }
                if ("service_lpar_id".equals(string)) {
                    if ("none".equals(string2.toLowerCase())) {
                        pICECDataBean.setServicePartition(new UnsignedInt16(65535));
                    } else {
                        pICECDataBean.setServicePartition(new UnsignedInt16(string2));
                    }
                    break block29;
                }
                if ("service_lpar_name".equals(string)) {
                    pICECDataBean.setServicePartitionName(string2);
                    break block29;
                }
                if ("power_on_side".equals(string)) {
                    if ("perm".equals(string2.toLowerCase())) {
                        pICECDataBean.setPlatformNextIplSide(new UnsignedInt8(0));
                    } else if ("temp".equals(string2.toLowerCase())) {
                        pICECDataBean.setPlatformNextIplSide(new UnsignedInt8(1));
                    } else {
                        bl = true;
                    }
                    break block29;
                }
                if ("power_on_speed".equals(string)) {
                    if ("slow".equals(string2.toLowerCase())) {
                        pICECDataBean.setPlatformNextIplSpeed(new UnsignedInt8(16));
                    } else if ("fast".equals(string2.toLowerCase())) {
                        pICECDataBean.setPlatformNextIplSpeed(new UnsignedInt8(255));
                    } else {
                        bl = true;
                    }
                    break block29;
                }
                if ("power_on_speed_override".equals(string)) {
                    if ("none".equals(string2.toLowerCase())) {
                        pICECDataBean.setPlatformNextIplSpeedOverride(new UnsignedInt8(0));
                    } else if ("slow".equals(string2.toLowerCase())) {
                        pICECDataBean.setPlatformNextIplSpeedOverride(new UnsignedInt8(16));
                    } else if ("fast".equals(string2.toLowerCase())) {
                        pICECDataBean.setPlatformNextIplSpeedOverride(new UnsignedInt8(255));
                    } else {
                        bl = true;
                    }
                    break block29;
                }
                if ("sys_time".equals(string)) {
                    pICECDataBean.setCecTimestamp(string2, "/ :");
                    break block29;
                }
                String[] stringArray2 = new String[]{string};
                throw new PIHscClientException("8000", "PIHscCmdLineBundle", "INVALID_ATTRIBUTE", stringArray2, null);
            }
            catch (NumberFormatException numberFormatException) {
                bl = true;
            }
        }
        if (bl) {
            stringArray = new String[]{string + "=" + string2};
            throw new PIHscClientException("8000", "PIHscCmdLineBundle", "INVALID_ATTRIBUTE_VALUE", stringArray, null);
        }
    }

    private void validateSysData(PICECDataBean pICECDataBean) throws PIHscClientException {
        String string = pICECDataBean.getUserDefinedName();
        String string2 = pICECDataBean.getCecTimestamp();
        UnsignedInt16 unsignedInt16 = pICECDataBean.getServicePartition();
        String string3 = pICECDataBean.getServicePartitionName();
        if (string != null) {
            try {
                if (!PIHscUtil.isCorrectNameLength(string, 63)) {
                    String[] stringArray = new String[]{string};
                    throw new PIHscClientException("8000", "PIHscCmdLineBundle", "INVALID_SYS_NAME_LENGTH", stringArray, null);
                }
                if (!PIHscUtil.nameHasCorrectCharacters(string)) {
                    String[] stringArray = new String[]{"new_name=" + string};
                    throw new PIHscClientException("8000", "PIHscCmdLineBundle", "INVALID_ATTRIBUTE_VALUE", stringArray, null);
                }
            }
            catch (CIMException cIMException) {
                String[] stringArray = new String[]{"new_name=" + string};
                throw new PIHscClientException("8000", "PIHscCmdLineBundle", "INVALID_ATTRIBUTE_VALUE", stringArray, null);
            }
        }
        if (string2 != null && !PIHscUtil.isValidTime(string2, "/ :")) {
            String[] stringArray = new String[]{"sys_time=" + string2};
            throw new PIHscClientException("8000", "PIHscCmdLineBundle", "INVALID_SYS_TIME_FORMAT", stringArray, null);
        }
        if (unsignedInt16 != null && unsignedInt16.intValue() != 65535) {
            String string4 = this.m_CECClient.getLparName(unsignedInt16);
            if (string4 == null) {
                String[] stringArray = new String[]{"service_lpar_id"};
                throw new PIHscClientException("8000", "HSCExceptionBundle", "8013", stringArray, null);
            }
            if (string3 != null && !string4.equals(string3)) {
                String[] stringArray = new String[]{unsignedInt16.toString(), string3};
                throw new PIHscClientException("8000", "PIHscCmdLineBundle", "PARTITION_ID_NAME_MISMATCH", stringArray, null);
            }
        } else if (string3 != null) {
            Vector vector = this.m_CECClient.getPartitionNames();
            String string5 = null;
            for (int i = 0; i < vector.size(); ++i) {
                String[] stringArray = (String[])vector.get(i);
                if (!string3.equals(stringArray[1])) continue;
                string5 = stringArray[0];
                break;
            }
            if (string5 == null) {
                String[] stringArray = new String[]{"service_lpar_name"};
                throw new PIHscClientException("8000", "HSCExceptionBundle", "8013", stringArray, null);
            }
            pICECDataBean.setServicePartition(new UnsignedInt16((int)this.m_CECClient.getPartitionSlotId(string5)));
        }
    }

    private void doFrameChange() throws PIHscClientException {
        PIFrameDataBean pIFrameDataBean = new PIFrameDataBean();
        CSVRecord cSVRecord = new CSVRecord((String)this.m_input.get(0), true, this.m_delimiter);
        Iterator iterator = cSVRecord.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            int n = string.indexOf("=");
            if (n == -1) {
                throw new PIHscClientException("8000", "PIHscCmdLineBundle", "INVALID_CFG_DATA", null, null);
            }
            String string2 = string.substring(0, n);
            String string3 = string.substring(n + 1);
            if (string2.length() == 0 || string3.length() == 0) {
                throw new PIHscClientException("8000", "PIHscCmdLineBundle", "INVALID_CFG_DATA", null, null);
            }
            this.setFrameData(pIFrameDataBean, string2, string3);
        }
        this.validateFrameData(pIFrameDataBean);
        this.m_FrameClient.setFrameDataBean(pIFrameDataBean);
    }

    private void doSystemChange() throws PIHscClientException {
        PICECDataBean pICECDataBean = new PICECDataBean();
        CSVRecord cSVRecord = new CSVRecord((String)this.m_input.get(0), true, this.m_delimiter);
        Iterator iterator = cSVRecord.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            int n = string.indexOf("=");
            if (n == -1) {
                throw new PIHscClientException("8000", "PIHscCmdLineBundle", "INVALID_CFG_DATA", null, null);
            }
            String string2 = string.substring(0, n);
            String string3 = string.substring(n + 1);
            if (string2.length() == 0 || string3.length() == 0) {
                throw new PIHscClientException("8000", "PIHscCmdLineBundle", "INVALID_CFG_DATA", null, null);
            }
            this.setSysData(pICECDataBean, string2, string3);
        }
        this.validateSysData(pICECDataBean);
        this.m_CECClient.setCECDataBean(pICECDataBean);
    }

    private void validatePartitionData(PILPARDataBean pILPARDataBean, PIHSCLPARClient pIHSCLPARClient) throws PIHscClientException {
        String[] stringArray;
        String string = pILPARDataBean.getUserDefinedName();
        String string2 = pILPARDataBean.getDefaultProfile();
        UnsignedInt16 unsignedInt16 = pILPARDataBean.getClusterID();
        UnsignedInt8 unsignedInt8 = pILPARDataBean.getIplSource();
        String string3 = null;
        if (string != null) {
            try {
                if (!PIHscUtil.isCorrectNameLength(string, 47)) {
                    String[] stringArray2 = new String[]{string};
                    throw new PIHscClientException("8000", "PIHscCmdLineBundle", "INVALID_PARTITION_NAME_LENGTH", stringArray2, null);
                }
                if (!PIHscUtil.nameHasCorrectCharacters(string)) {
                    string3 = "new_name=" + string;
                }
            }
            catch (CIMException cIMException) {
                string3 = "new_name=" + string;
            }
        }
        if (string2 != null && string3 == null) {
            try {
                if (!PIHscUtil.isCorrectNameLength(string2, 31)) {
                    String[] stringArray3 = new String[]{string2};
                    throw new PIHscClientException("8000", "PIHscCmdLineBundle", "INVALID_PROF_NAME_LENGTH", stringArray3, null);
                }
                if (!PIHscUtil.nameHasCorrectCharacters(string2)) {
                    string3 = "default_profile=" + string2;
                }
            }
            catch (CIMException cIMException) {
                string3 = "default_profile=" + string2;
            }
        }
        if (unsignedInt16 != null && unsignedInt16.intValue() != 65535 && string3 == null && unsignedInt16.intValue() > Short.MAX_VALUE) {
            string3 = "work_group_id=" + unsignedInt16;
        }
        if (unsignedInt8 != null && (stringArray = pIHSCLPARClient.getLPARDataBean(new String[]{"resource_config"})).isRPA()) {
            String[] stringArray4 = new String[]{"ipl_source"};
            throw new PIHscClientException("8000", "PIHscCmdLineBundle", "ATTR_ONLY_VALID_FOR_OS400", stringArray4, null);
        }
        if (string3 != null) {
            stringArray = new String[]{string3};
            throw new PIHscClientException("8000", "PIHscCmdLineBundle", "INVALID_ATTRIBUTE_VALUE", stringArray, null);
        }
    }

    private void doPartitionChange() throws PIHscClientException {
        for (int i = 0; i < this.m_input.size(); ++i) {
            Object object;
            PILPARDataBean pILPARDataBean = new PILPARDataBean();
            CSVRecord cSVRecord = new CSVRecord((String)this.m_input.get(i), true, this.m_delimiter);
            Iterator iterator = cSVRecord.iterator();
            while (iterator.hasNext()) {
                String[] stringArray;
                object = (String[])iterator.next();
                int n = object.indexOf("=");
                if (n == -1) {
                    throw new PIHscClientException("8000", "PIHscCmdLineBundle", "INVALID_CFG_DATA", null, null);
                }
                String string = object.substring(0, n);
                String string2 = object.substring(n + 1);
                if (string.length() == 0 || string2.length() == 0) {
                    throw new PIHscClientException("8000", "PIHscCmdLineBundle", "INVALID_CFG_DATA", null, null);
                }
                if ("lpar_id".equals(string)) {
                    this.m_partID = string2;
                    continue;
                }
                if ("name".equals(string)) {
                    this.m_partName = string2;
                    continue;
                }
                if ("new_name".equals(string)) {
                    pILPARDataBean.setUserDefinedName(string2);
                    continue;
                }
                if ("default_profile".equals(string)) {
                    pILPARDataBean.setDefaultProfile(string2);
                    continue;
                }
                if ("work_group_id".equals(string)) {
                    if ("none".equals(string2.toLowerCase())) {
                        pILPARDataBean.setClusterID(new UnsignedInt16(65535));
                        continue;
                    }
                    try {
                        pILPARDataBean.setClusterID(new UnsignedInt16(string2));
                        continue;
                    }
                    catch (NumberFormatException numberFormatException) {
                        String[] stringArray2 = new String[]{object};
                        throw new PIHscClientException("8000", "PIHscCmdLineBundle", "INVALID_ATTRIBUTE_VALUE", stringArray2, null);
                    }
                }
                if ("ipl_source".equals(string)) {
                    stringArray = PIHMCCommandUtils.decodeIplSourceString(string2);
                    if (stringArray != null) {
                        pILPARDataBean.setIplSource((UnsignedInt8)stringArray);
                        continue;
                    }
                    String[] stringArray3 = new String[]{object};
                    throw new PIHscClientException("8000", "PIHscCmdLineBundle", "INVALID_ATTRIBUTE_VALUE", stringArray3, null);
                }
                if ("shared_proc_pool_util_auth".equals(string)) {
                    if (PIHMCCommandUtils.decodeBoolean(string2) != null) {
                        pILPARDataBean.setSharedPoolUtilizationAuthority(new UnsignedInt8(string2));
                        continue;
                    }
                    stringArray = new String[]{object};
                    throw new PIHscClientException("8000", "PIHscCmdLineBundle", "INVALID_ATTRIBUTE_VALUE", stringArray, null);
                }
                stringArray = new String[]{string};
                throw new PIHscClientException("8000", "PIHscCmdLineBundle", "INVALID_ATTRIBUTE", stringArray, null);
            }
            if (this.m_partID == null && this.m_partName == null) {
                object = new String[]{"name | lpar_id"};
                throw new PIHscClientException("8000", "PIHscCmdLineBundle", "REQUIRED_ATTRIBUTE_ERROR", (String[])object, null);
            }
            if (this.m_partID != null && this.m_partName != null) {
                object = new String[]{"name, lpar_id"};
                throw new PIHscClientException("8000", "PIHscCmdLineBundle", "MUTUALLY_EXCLUSIVE_ATTRIBUTES", (String[])object, null);
            }
            object = null;
            object = this.m_partName != null ? this.m_factory.createLPARClient(this.m_managedSystem, this.m_partName, false) : this.m_factory.createLPARClient(this.m_managedSystem, this.m_partID, true);
            if (object == null) {
                if (this.m_partName != null) {
                    String[] stringArray = new String[]{this.m_partName};
                    throw new PIHscClientException("8000", "HSCExceptionBundle", "8012", stringArray, null);
                }
                String[] stringArray = new String[]{this.m_partID};
                throw new PIHscClientException("8000", "HSCExceptionBundle", "8011", stringArray, null);
            }
            this.validatePartitionData(pILPARDataBean, (PIHSCLPARClient)object);
            object.setLPARDataBean(pILPARDataBean);
            this.m_partName = null;
            this.m_partID = null;
        }
    }

    private void doProfileChange() throws PIHscClientException {
        String[] stringArray = null;
        String string = null;
        String string2 = null;
        String string3 = null;
        PIHSCProfileCIMClient pIHSCProfileCIMClient = null;
        PIHSCLPARClient pIHSCLPARClient = null;
        for (int i = 0; i < this.m_input.size(); ++i) {
            Object object;
            PILPARProfileDataBean pILPARProfileDataBean = new PILPARProfileDataBean();
            Boolean[] booleanArray = new Boolean[6];
            pILPARProfileDataBean.setTaggedIOInfo(booleanArray);
            CSVRecord cSVRecord = new CSVRecord((String)this.m_input.get(i), true, this.m_delimiter);
            Iterator iterator = cSVRecord.iterator();
            Vector<String> vector = new Vector<String>();
            boolean bl = false;
            while (iterator.hasNext()) {
                object = (String)iterator.next();
                int n = ((String)object).indexOf("=");
                if (n == -1) {
                    throw new PIHscClientException("8000", "PIHscCmdLineBundle", "INVALID_CFG_DATA", null, null);
                }
                String string4 = ((String)object).substring(0, n);
                String string5 = ((String)object).substring(n + 1);
                if (string4.length() == 0 || string5.length() == 0) {
                    throw new PIHscClientException("8000", "PIHscCmdLineBundle", "INVALID_CFG_DATA", null, null);
                }
                if ("name".equals(string4)) {
                    this.m_partProfName = string5;
                    continue;
                }
                if ("new_name".equals(string4)) {
                    pILPARProfileDataBean.setName(string5);
                    continue;
                }
                if (PARTITION_NAME_ATTR.equals(string4)) {
                    string = string5;
                    continue;
                }
                if ("lpar_id".equals(string4)) {
                    string2 = string5 + "*" + this.m_intSysName;
                    continue;
                }
                if ("all_resources".equals(string4)) {
                    throw new PIHscClientException("8000", "PIHscCmdLineBundle", "INVALID_ATTRIBUTE", new String[]{string4}, null);
                }
                PIProfCommandUtils.setProfBean(pILPARProfileDataBean, string4, string5, this.m_intSysName, 1);
                vector.add(string4);
            }
            if (this.m_partProfName == null) {
                stringArray = new String[]{"name"};
                throw new PIHscClientException("8000", "PIHscCmdLineBundle", "REQUIRED_ATTRIBUTE_ERROR", stringArray, null);
            }
            if (string2 == null && string == null) {
                stringArray = new String[]{"lpar_name | lpar_id"};
                throw new PIHscClientException("8000", "PIHscCmdLineBundle", "REQUIRED_ATTRIBUTE_ERROR", stringArray, null);
            }
            if (string2 != null && string != null) {
                stringArray = new String[]{"lpar_name, lpar_id"};
                throw new PIHscClientException("8000", "PIHscCmdLineBundle", "MUTUALLY_EXCLUSIVE_ATTRIBUTES", stringArray, null);
            }
            pIHSCLPARClient = string2 != null ? this.m_factory.createLPARClient(this.m_managedSystem, string2, true) : this.m_factory.createLPARClient(this.m_managedSystem, string, false);
            if (pIHSCLPARClient == null) {
                if (string != null) {
                    stringArray = new String[]{string};
                    throw new PIHscClientException("8000", "HSCExceptionBundle", "8012", stringArray, null);
                }
                stringArray = new String[]{string2.substring(0, string2.indexOf(42))};
                throw new PIHscClientException("8000", "HSCExceptionBundle", "8011", stringArray, null);
            }
            pIHSCProfileCIMClient = string2 != null ? this.m_factory.createProfileClient(this.m_managedSystem, string2, this.m_partProfName, true, false) : this.m_factory.createProfileClient(this.m_managedSystem, string, this.m_partProfName, false, false);
            if (pIHSCProfileCIMClient == null) {
                stringArray = new String[]{this.m_partProfName};
                throw new PIHscClientException("8000", "HSCExceptionBundle", "800F", stringArray, null);
            }
            object = pIHSCProfileCIMClient.getLPARProfileDataBean();
            PILPARDataBean pILPARDataBean = pIHSCLPARClient.getLPARDataBean(new String[]{"resource_config"});
            if (((PILPARProfileDataBean)object).getProfileType().intValue() == 1) {
                for (int j = 0; j < vector.size(); ++j) {
                    string3 = (String)vector.get(j);
                    if (string3.equals("auto_start") || string3.equals("boot_mode") || string3.equals("load_source_slot") || string3.equals("alt_restart_device_slot") || string3.equals("console_slot") || string3.equals("alt_console_slot") || string3.equals("op_console_slot") || string3.equals("conn_monitoring") || string3.equals("lpar_id") || string3.equals("name") || string3.equals(PARTITION_NAME_ATTR)) continue;
                    throw new PIHscClientException("8000", "PIHscCmdLineBundle", "INVALID_ATTRIBUTE", new String[]{string3}, null);
                }
            }
            int n = pILPARDataBean.getDefinitionState().intValue();
            pILPARProfileDataBean.setLparId(pILPARDataBean.m_internalName);
            pILPARProfileDataBean.setOsType(PILPARProfileDataBean.mapDefinitionStateToOsType(n));
            PIProfCommandUtils.mergeProfInfo(pILPARProfileDataBean, (PILPARProfileDataBean)object, this.m_CECClient);
            PIProfCommandUtils.advValidateProfile(pILPARProfileDataBean, this.m_CECClient);
            pIHSCProfileCIMClient.setLPARProfileDataBean(pILPARProfileDataBean);
            this.m_partProfName = null;
            string = null;
            string2 = null;
        }
    }

    private void setSysProfData(PISysProfDataBean pISysProfDataBean, String string, String string2) throws PIHscClientException {
        if ("name".equals(string)) {
            this.m_sysProfName = string2;
        } else if ("new_name".equals(string)) {
            pISysProfDataBean.setName(string2);
        } else if ("lpar_ids".equals(string)) {
            String[] stringArray = PIHMCCommandUtils.parseList(string2, this.m_delimiter);
            pISysProfDataBean.setPartIDs(stringArray);
        } else if ("lpar_ids+".equals(string)) {
            String[] stringArray = PIHMCCommandUtils.parseList(string2, this.m_delimiter);
            pISysProfDataBean.setPartIDsAdd(stringArray);
        } else if ("lpar_ids-".equals(string)) {
            String[] stringArray = PIHMCCommandUtils.parseList(string2, this.m_delimiter);
            pISysProfDataBean.setPartIDsDel(stringArray);
        } else if ("lpar_names".equals(string)) {
            String[] stringArray = PIHMCCommandUtils.parseList(string2, this.m_delimiter);
            pISysProfDataBean.setPartNames(stringArray);
        } else if ("lpar_names+".equals(string)) {
            String[] stringArray = PIHMCCommandUtils.parseList(string2, this.m_delimiter);
            pISysProfDataBean.setPartNamesAdd(stringArray);
        } else if ("lpar_names-".equals(string)) {
            String[] stringArray = PIHMCCommandUtils.parseList(string2, this.m_delimiter);
            pISysProfDataBean.setPartNamesDel(stringArray);
        } else if ("profile_names".equals(string)) {
            String[] stringArray = PIHMCCommandUtils.parseList(string2, this.m_delimiter);
            pISysProfDataBean.setProfNames(stringArray);
        } else if ("profile_names+".equals(string)) {
            String[] stringArray = PIHMCCommandUtils.parseList(string2, this.m_delimiter);
            pISysProfDataBean.setProfNamesAdd(stringArray);
        } else if ("profile_names-".equals(string)) {
            String[] stringArray = PIHMCCommandUtils.parseList(string2, this.m_delimiter);
            pISysProfDataBean.setProfNamesDel(stringArray);
        } else {
            String[] stringArray = new String[]{string};
            throw new PIHscClientException("8000", "PIHscCmdLineBundle", "INVALID_ATTRIBUTE", stringArray, null);
        }
    }

    private void validateSysProfData(PISysProfDataBean pISysProfDataBean) throws PIHscClientException {
        int n;
        int n2;
        String[] stringArray;
        boolean bl;
        String string = pISysProfDataBean.getName();
        String[] stringArray2 = pISysProfDataBean.getPartIDs();
        String[] stringArray3 = pISysProfDataBean.getPartIDsAdd();
        String[] stringArray4 = pISysProfDataBean.getPartIDsDel();
        String[] stringArray5 = pISysProfDataBean.getPartNames();
        String[] stringArray6 = pISysProfDataBean.getPartNamesAdd();
        String[] stringArray7 = pISysProfDataBean.getPartNamesDel();
        String[] stringArray8 = pISysProfDataBean.getProfNames();
        String[] stringArray9 = pISysProfDataBean.getProfNamesAdd();
        String[] stringArray10 = pISysProfDataBean.getProfNamesDel();
        if (this.m_sysProfName == null) {
            String[] stringArray11 = new String[]{"name"};
            throw new PIHscClientException("8000", "PIHscCmdLineBundle", "REQUIRED_ATTRIBUTE_ERROR", stringArray11, null);
        }
        if (string != null) {
            try {
                if (!PIHscUtil.isCorrectNameLength(string, 31)) {
                    String[] stringArray12 = new String[]{string};
                    throw new PIHscClientException("8000", "PIHscCmdLineBundle", "INVALID_PROF_NAME_LENGTH", stringArray12, null);
                }
                if (!PIHscUtil.nameHasCorrectCharacters(string)) {
                    String[] stringArray13 = new String[]{"new_name=" + string};
                    throw new PIHscClientException("8000", "PIHscCmdLineBundle", "INVALID_ATTRIBUTE_VALUE", stringArray13, null);
                }
            }
            catch (CIMException cIMException) {
                String[] stringArray14 = new String[]{"new_name=" + string};
                throw new PIHscClientException("8000", "PIHscCmdLineBundle", "INVALID_ATTRIBUTE_VALUE", stringArray14, null);
            }
        }
        boolean bl2 = stringArray2 != null || stringArray3 != null || stringArray4 != null;
        boolean bl3 = bl = stringArray5 != null || stringArray6 != null || stringArray7 != null;
        if (bl2 && bl) {
            String[] stringArray15 = new String[]{"lpar_ids, lpar_names"};
            throw new PIHscClientException("8000", "PIHscCmdLineBundle", "MUTUALLY_EXCLUSIVE_ATTRIBUTES", stringArray15, null);
        }
        if (stringArray5 != null && (stringArray6 != null || stringArray7 != null)) {
            String[] stringArray16 = new String[]{"lpar_names"};
            throw new PIHscClientException("8000", "PIHscCmdLineBundle", "ATTRIBUTE_OPERATOR_COLLISION", stringArray16, null);
        }
        if (stringArray2 != null && (stringArray3 != null || stringArray4 != null)) {
            String[] stringArray17 = new String[]{"lpar_ids"};
            throw new PIHscClientException("8000", "PIHscCmdLineBundle", "ATTRIBUTE_OPERATOR_COLLISION", stringArray17, null);
        }
        if (stringArray8 != null && (stringArray9 != null || stringArray10 != null)) {
            String[] stringArray18 = new String[]{"profile_names"};
            throw new PIHscClientException("8000", "PIHscCmdLineBundle", "ATTRIBUTE_OPERATOR_COLLISION", stringArray18, null);
        }
        String[] stringArray19 = bl2 ? stringArray2 : stringArray5;
        String[] stringArray20 = bl2 ? stringArray3 : stringArray6;
        String[] stringArray21 = stringArray = bl2 ? stringArray4 : stringArray7;
        if (stringArray8 != null && stringArray19 != null && stringArray8.length != stringArray19.length || stringArray9 != null && stringArray20 != null && stringArray9.length != stringArray20.length || stringArray10 != null && stringArray != null && stringArray10.length != stringArray.length || stringArray8 == null && stringArray19 != null || stringArray9 == null && stringArray20 != null || stringArray10 == null && stringArray != null) {
            String[] stringArray22 = new String[]{this.m_sysProfName};
            throw new PIHscClientException("8000", "PIHscCmdLineBundle", "INVALID_SYSPROF_LIST_LENGTHS", stringArray22, null);
        }
        if (stringArray19 != null) {
            for (n2 = 0; n2 < stringArray19.length; ++n2) {
                for (n = n2 + 1; n < stringArray19.length; ++n) {
                    if (!stringArray19[n2].equals(stringArray19[n])) continue;
                    String[] stringArray23 = new String[]{this.m_sysProfName};
                    throw new PIHscClientException("8000", "PIHscCmdLineBundle", "DUPLICATE_PARTITIONS", stringArray23, null);
                }
            }
        }
        if (stringArray20 != null) {
            for (n2 = 0; n2 < stringArray20.length; ++n2) {
                for (n = n2 + 1; n < stringArray20.length; ++n) {
                    if (!stringArray20[n2].equals(stringArray20[n])) continue;
                    String[] stringArray24 = new String[]{this.m_sysProfName};
                    throw new PIHscClientException("8000", "PIHscCmdLineBundle", "DUPLICATE_PARTITIONS", stringArray24, null);
                }
            }
        }
        if (stringArray != null) {
            for (n2 = 0; n2 < stringArray.length; ++n2) {
                for (n = n2 + 1; n < stringArray.length; ++n) {
                    if (!stringArray[n2].equals(stringArray[n])) continue;
                    String[] stringArray25 = new String[]{this.m_sysProfName};
                    throw new PIHscClientException("8000", "PIHscCmdLineBundle", "DUPLICATE_PARTITIONS", stringArray25, null);
                }
            }
        }
    }

    private void doSysProfChange() throws PIHscClientException {
        PIHSCSysProfClient pIHSCSysProfClient = null;
        for (int i = 0; i < this.m_input.size(); ++i) {
            String[] stringArray;
            PISysProfDataBean pISysProfDataBean = new PISysProfDataBean();
            CSVRecord cSVRecord = new CSVRecord((String)this.m_input.get(i), true, this.m_delimiter);
            Iterator iterator = cSVRecord.iterator();
            while (iterator.hasNext()) {
                stringArray = (String[])iterator.next();
                int n = stringArray.indexOf("=");
                if (n == -1) {
                    throw new PIHscClientException("8000", "PIHscCmdLineBundle", "INVALID_CFG_DATA", null, null);
                }
                String string = stringArray.substring(0, n);
                String string2 = stringArray.substring(n + 1);
                if (string.length() == 0 || string2.length() == 0) {
                    throw new PIHscClientException("8000", "PIHscCmdLineBundle", "INVALID_CFG_DATA", null, null);
                }
                this.setSysProfData(pISysProfDataBean, string, string2);
            }
            this.validateSysProfData(pISysProfDataBean);
            pIHSCSysProfClient = this.m_factory.createSysProfClient(this.m_CECClient, this.m_sysProfName);
            if (pIHSCSysProfClient == null) {
                stringArray = new String[]{this.m_sysProfName};
                throw new PIHscClientException("8000", "HSCExceptionBundle", "8010", stringArray, null);
            }
            pIHSCSysProfClient.changeSysProf(pISysProfDataBean);
            this.m_sysProfName = null;
        }
    }

    private void performCommand() throws PIHscClientException {
        String string = null;
        this.checkParameters();
        if (this.m_CECClient != null) {
            PICECDataBean pICECDataBean = this.m_CECClient.getCECDataBean(new String[]{"state"});
            int n = pICECDataBean.getCecState().intValue();
            if ("sys".equals(this.m_resourceType)) {
                if (n == 254 || n == 241 || n == 242 || n == 250) {
                    String[] stringArray = new String[]{pICECDataBean.getCECStateString()};
                    throw new PIHscClientException("8000", "HSCCIMExceptionBundle", "0237", stringArray, null);
                }
            } else if ("lpar".equals(this.m_resourceType) || "prof".equals(this.m_resourceType)) {
                if (n != 17 && n != 1) {
                    throw new PIHscClientException("8000", "HSCCIMExceptionBundle", "9010", null, null);
                }
            } else {
                if (n == 254 || n == 241 || n == 242 || n == 250) {
                    String[] stringArray = new String[]{pICECDataBean.getCECStateString()};
                    throw new PIHscClientException("8000", "HSCCIMExceptionBundle", "0237", stringArray, null);
                }
                if (n == 251 || n == 253) {
                    String[] stringArray = new String[]{pICECDataBean.getCECStateString()};
                    throw new PIHscClientException("8000", "HSCCIMExceptionBundle", "0239", stringArray, null);
                }
            }
        }
        try {
            string = InetAddress.getLocalHost().getHostName();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.m_factory = PIHSCClientObjectFactory.getInstance(string, null);
        if ("sys".equals(this.m_resourceType)) {
            this.doSystemChange();
        } else if ("lpar".equals(this.m_resourceType)) {
            this.doPartitionChange();
        } else if ("prof".equals(this.m_resourceType)) {
            this.doProfileChange();
        } else if ("frame".equals(this.m_resourceType)) {
            this.doFrameChange();
        } else {
            this.doSysProfChange();
        }
    }

    private void checkParameters() throws PIHscClientException {
        String string = "";
        if (!(this.m_resourceType != null && ("sys".equals(this.m_resourceType) || "lpar".equals(this.m_resourceType) || "prof".equals(this.m_resourceType) || "frame".equals(this.m_resourceType) || "sysprof".equals(this.m_resourceType)))) {
            string = "-r";
        }
        if (!(this.m_filename != null && this.m_filename.length() != 0 || this.m_inputData != null && this.m_inputData.length() != 0)) {
            string = string + ", -f | -i";
        }
        if (string.length() > 0) {
            if (string.startsWith(", ")) {
                string = string.substring(2, string.length());
            }
            String[] stringArray = new String[]{string};
            throw new PIHscClientException("8000", "PIHscCmdLineBundle", "REQUIRED_PARMS_ERROR", stringArray, null);
        }
        if (this.m_input == null || this.m_input.size() == 0) {
            String[] stringArray = new String[]{this.m_filename};
            throw new PIHscClientException("8000", "PIHscCmdLineBundle", "FILE_NOT_FOUND", stringArray, null);
        }
        if ("frame".equals(this.m_resourceType) && this.m_managedSystem != null) {
            String[] stringArray = new String[]{"-m", this.m_resourceType};
            throw new PIHscClientException("8000", "PIHscCmdLineBundle", "INVALID_PARM_FOR_RESOURCE", stringArray, null);
        }
        if (!"frame".equals(this.m_resourceType) && this.m_frame != null) {
            String[] stringArray = new String[]{"-e", this.m_resourceType};
            throw new PIHscClientException("8000", "PIHscCmdLineBundle", "INVALID_PARM_FOR_RESOURCE", stringArray, null);
        }
    }

    private void mapParameters(HashMap hashMap) throws PIHscClientException {
        this.m_managedSystem = (String)hashMap.get("-m");
        this.m_resourceType = (String)hashMap.get("-r");
        this.m_filename = (String)hashMap.get("-f");
        this.m_inputData = (String)hashMap.get("-i");
        this.m_frame = (String)hashMap.get("-e");
        if (this.m_inputData != null && this.m_filename != null) {
            String[] stringArray = new String[]{"[-f | -i]"};
            throw new PIHscClientException("8000", "PIHscCmdLineBundle", "MUTUALLY_EXCLUSIVE_PARMS", stringArray, null);
        }
        this.m_input = new Vector();
        if (this.m_inputData != null) {
            this.m_input.add(this.m_inputData);
        } else if (this.m_filename != null) {
            try {
                this.m_input = PIHMCCommandUtils.readInputFile(this.m_filename);
            }
            catch (FileNotFoundException fileNotFoundException) {
                String[] stringArray = new String[]{this.m_filename};
                throw new PIHscClientException("8000", "PIHscCmdLineBundle", "FILE_NOT_FOUND", stringArray, null);
            }
            catch (IOException iOException) {
                String[] stringArray = new String[]{this.m_filename};
                throw new PIHscClientException("8000", "HSCExceptionBundle", "800E", stringArray, null);
            }
        }
        this.handleDeprecatedSyntax(hashMap);
    }

    private void handleDeprecatedSyntax(HashMap hashMap) throws PIHscClientException {
        String string = (String)hashMap.get("-n");
        if (string != null) {
            throw new PIHscClientException("8000", "PIHscCmdLineBundle", "DEPRECATED_CHSYSCFG_N_PARM", null, null);
        }
        String string2 = (String)hashMap.get("-p");
        if (string2 != null) {
            throw new PIHscClientException("8000", "PIHscCmdLineBundle", "DEPRECATED_CHSYSCFG_P_PARM", null, null);
        }
    }

    public static void printHelp(PrintStream printStream, boolean bl) {
        if (bl) {
            printStream.print('\u0000');
        }
        printStream.println(HSCResourceBundleUtil.getMessage("PIHscCmdLineBundle", "CHSYSCFG_HELP_GA3"));
        printStream.println(HSCResourceBundleUtil.getMessage("PIHscCmdLineBundle", "CHSYSCFG_ATTR_HELP_GA3"));
    }

    public static int callCommandFromRouter(PIHSCFrameClient pIHSCFrameClient, PIHSCCECClient pIHSCCECClient, String[] stringArray, PrintStream printStream, boolean bl) {
        int n = 0;
        ArrayList<String> arrayList = new ArrayList<String>(stringArray.length);
        PISystemConfigurationChange pISystemConfigurationChange = new PISystemConfigurationChange(pIHSCFrameClient, pIHSCCECClient, printStream, bl);
        try {
            for (int i = 0; i < stringArray.length; ++i) {
                arrayList.add(stringArray[i]);
            }
            HashMap hashMap = PIHMCCommandUtils.parseParameters(arrayList, pISystemConfigurationChange.m_validParms);
            pISystemConfigurationChange.mapParameters(hashMap);
            pISystemConfigurationChange.performCommand();
        }
        catch (PIHscClientException pIHscClientException) {
            if (bl) {
                printStream.print('\u0001');
                bl = false;
            }
            pIHscClientException.printStackTrace(System.out);
            if ("8000".equals(pIHscClientException.getHscExId())) {
                printStream.println(pIHscClientException.getMessage());
            } else {
                String string;
                if ("sys".equals(pISystemConfigurationChange.m_resourceType)) {
                    Object[] objectArray = new String[]{pISystemConfigurationChange.m_managedSystem};
                    string = HSCResourceBundleUtil.getMessage("PIHscCmdLineBundle", "CHANGE_SYSTEM_ERROR", "", objectArray);
                } else if ("lpar".equals(pISystemConfigurationChange.m_resourceType)) {
                    if (pISystemConfigurationChange.m_partName != null) {
                        Object[] objectArray = new String[]{pISystemConfigurationChange.m_partName};
                        string = HSCResourceBundleUtil.getMessage("PIHscCmdLineBundle", "CHANGE_PARTITION_NAME_ERROR", "", objectArray);
                    } else {
                        Object[] objectArray = new String[]{pISystemConfigurationChange.m_partID};
                        string = HSCResourceBundleUtil.getMessage("PIHscCmdLineBundle", "CHANGE_PARTITION_ID_ERROR", "", objectArray);
                    }
                } else if ("prof".equals(pISystemConfigurationChange.m_resourceType)) {
                    Object[] objectArray = new String[]{pISystemConfigurationChange.m_partProfName};
                    string = HSCResourceBundleUtil.getMessage("PIHscCmdLineBundle", "CHANGE_PROF_ERROR", "", objectArray);
                } else if ("frame".equals(pISystemConfigurationChange.m_resourceType)) {
                    Object[] objectArray = new String[]{pISystemConfigurationChange.m_frame};
                    string = HSCResourceBundleUtil.getMessage("PIHscCmdLineBundle", "CHANGE_FRAME_ERROR", "", objectArray);
                } else {
                    Object[] objectArray = new String[]{pISystemConfigurationChange.m_sysProfName};
                    string = HSCResourceBundleUtil.getMessage("PIHscCmdLineBundle", "CHANGE_SYS_PROF_ERROR", "", objectArray);
                }
                printStream.println(string);
                string = pIHscClientException.getMessage();
                if (string == null || string.length() == 0) {
                    string = HSCResourceBundleUtil.getMessage("HSCExceptionBundle", "8016");
                }
                printStream.println(string);
            }
            n = 1;
        }
        catch (Exception exception) {
            if (bl) {
                printStream.print('\u0001');
                bl = false;
            }
            exception.printStackTrace(System.out);
            String string = "";
            if ("sys".equals(pISystemConfigurationChange.m_resourceType)) {
                Object[] objectArray = new String[]{pISystemConfigurationChange.m_managedSystem};
                string = HSCResourceBundleUtil.getMessage("PIHscCmdLineBundle", "CHANGE_SYSTEM_ERROR", "", objectArray);
            } else if ("lpar".equals(pISystemConfigurationChange.m_resourceType)) {
                if (pISystemConfigurationChange.m_partName != null) {
                    Object[] objectArray = new String[]{pISystemConfigurationChange.m_partName};
                    string = HSCResourceBundleUtil.getMessage("PIHscCmdLineBundle", "CHANGE_PARTITION_NAME_ERROR", "", objectArray);
                } else {
                    Object[] objectArray = new String[]{pISystemConfigurationChange.m_partID};
                    string = HSCResourceBundleUtil.getMessage("PIHscCmdLineBundle", "CHANGE_PARTITION_ID_ERROR", "", objectArray);
                }
            } else if ("prof".equals(pISystemConfigurationChange.m_resourceType)) {
                Object[] objectArray = new String[]{pISystemConfigurationChange.m_partProfName};
                string = HSCResourceBundleUtil.getMessage("PIHscCmdLineBundle", "CHANGE_PROF_ERROR", "", objectArray);
            } else if ("frame".equals(pISystemConfigurationChange.m_resourceType)) {
                Object[] objectArray = new String[]{pISystemConfigurationChange.m_frame};
                string = HSCResourceBundleUtil.getMessage("PIHscCmdLineBundle", "CHANGE_FRAME_ERROR", "", objectArray);
            } else {
                Object[] objectArray = new String[]{pISystemConfigurationChange.m_sysProfName};
                string = HSCResourceBundleUtil.getMessage("PIHscCmdLineBundle", "CHANGE_SYS_PROF_ERROR", "", objectArray);
            }
            printStream.println(string);
            string = HSCResourceBundleUtil.getMessage("HSCExceptionBundle", "8016");
            printStream.println(string);
            n = 1;
        }
        if (bl) {
            printStream.print('\u0000');
        }
        return n;
    }
}

